
// Updated: 18th August 2004

private import std.dtl.containers.vector;
private import std.dtl.interfaces.container;
private import std.dtl.interfaces.objectcontainer;

private import std.stdio;

/* ////////////////////////////////////////////////////////////////////////// */

void dump_IObjectContainer(IObjectContainer cont)
{
	printf("dump_IObjectContainer: ");
	for(IObjectEnumerator en = cont.enumerate(); en.hasMoreElements(); )
	{
		printf("%.*s ", en.nextElement().toString);
	}
	printf("\n");
}

template dump(T) { void dump(IContainer!(T) cont)
{
	writef("dump [%p]: ", cont);
	for(interface_type_ e = cont.enumerate(); e.hasMoreElements(); )
	{
		writef(e.value);
	}
	writefln("");
}}

template Algorithm(R)
{
public:
    typedef R               range_type;
    typedef R.value_type    value_type;



    R copy(R dest, R src)
    {
        return dest;
    }
}

struct Sorter
{
    int opCall(int lhs, int rhs)
    {
        return lhs < rhs;
    }
}

void Vector_test_int()
{
    alias Vector!(int)       vector_t;

    void dump(vector_t v)
    {
        printf("Vector(%p) [%2u, %2u]:", v, v.length, v.capacity);
        if(0 != v.length)
        {
            printf("  [");
//              foreach(int i; v)
//              {
//                  printf("%d ", i);
//              }
            for(int i = 0; i < v.length; ++i)
            {
                printf("%d ", v[i]);
            }
            printf("]\n");
        }
    }

    printf("Vector test (int)\n");
    printf("----------------\n");


    printf("\nCreating a new vector:\n");
    vector_t    v    = new vector_t;
    dump(v);


    printf("\nPushing elements to vector:\n");
    for(int i = 0; i < 20; i += 2)
    {
        v.push_back(i);
    }
    dump(v);


    printf("\nCopying vector:\n");
    vector_t    s2   = new vector_t(v);
    dump(s2);


    printf("\nPopping elements from vector\n");
    dump(v);
    while(!v.isEmpty())
    {
        printf("Deleting ");
        if( 1 == (v.length % 2) &&
            v.length > 5)
        {
            printf("[2, 4]\n");
            v.erase(2, 4);
        }
        else
        {
            printf("[%d]\n", v.length <= 3 ? 0 : 3);
            v.erase(v.length <= 3 ? 0 : 3);
        }
        dump(v);
    }

    printf("\nPushing more elements on to vector:\n");
    for(int i = 0; i < 10; ++i)
    {
        v.push_back(i);
        dump(v);
    }

    printf("\nReversing elements in place:\n");
    v.reverse();
    dump(v);

/+
    printf("\nSorting elements in place:\n");
    Sorter  sorter;
    v.sortWith!(int)(sorter);
    dump(v);
+/

    printf("\nSorting elements in place:\n");
    v.sort();
    dump(v);


	printf("\nNow using transformations:\n--------------------------\n");

	bool IsOdd(int i)
	{
		return 0 != (i & 0x1);
	}

	int SquareOf(int i)
	{
		return i * i;
	}

	printf("\nselect()-ing odd numbers:\n");
	foreach(int i; v.select(&IsOdd))
	{
		printf("%d ", i);
	}
	printf("\n");

	printf("\ntransform()-ing squares of numbers:\n");
	foreach(int i; v.transform(&SquareOf))
	{
		printf("%d ", i);
	}
	printf("\n");
}

void Vector_test_IContainer_int()
{
//	alias	IContainer!(int)		icontainer_t;

//    alias Vector!(int, IContainer!(int))	vector_t;

}


int main()
{
    Vector_test_int();
    Vector_test_IContainer_int();
//      Vector_test_Point();
//      Vector_test_Person();

    return 0;
}
