
// Updated: 31st July 2004

import std.dtl.containers.queue;
import std.dtl.interfaces.container;
import std.dtl.interfaces.objectcontainer;

void dump_IObjectContainer(IObjectContainer cont)
{
	printf("dump_IObjectContainer: ");
	for(IObjectEnumerator en = cont.enumerate(); en.hasMoreElements(); )
	{
		printf("%.*s ", en.nextElement().toString);
	}
	printf("\n");
}

/+
void dump_IContainer_int(IContainer!(int) cont)
{
	printf("dump_IContainer!(int): ");
	for(IEnumerator!(int) en = cont.enumerate(); en.hasMoreElements(); )
	{
		printf("%d ", en.nextElement());
	}
	printf("\n");
}
+/

void Queue_test_int()
{
	printf("Queue!(int)\n");

	alias Queue!(int)		container_t;

	container_t	cont1	=	new container_t();

	// 1. push()
	printf("\nTEST: push()\n");
	printf("Populate the container with 10 integers, using push()\n");
	for(int i = 0; i < 10; ++i)
	{
		cont1.push(i);
	}
	printf("Contents: ");
	foreach(int i; cont1)
	{
		printf("%d ", i);
	}
	printf("\n");

	// 2. length()
	printf("\nTEST: length()\n");
	printf("length: %u\n", cont1.length);

	// 3. Copying a container
	printf("\nTEST: copy-constructor\n");
	container_t	cont2	=	new container_t(cont1);

	// 4. pop()
	printf("\nTEST: pop()\n");
	printf("Now pop the elements (from the original), one at a time\n");
	while(cont1.length())
	{
		printf("top: %d\n", cont1.top);
		cont1.pop();
	}

	// 5. clear()
	printf("\nTEST: clear()\n");
	printf("Clear all elements from the copy\n");
	printf("length before: %u\n", cont2.length);
	cont2.clear();
	printf("length after: %u\n", cont2.length);

}

void Queue_test_int_IObjectContainer()
{
	printf("Queue!(int, IObjectContainer)\n");

	alias Queue!(int, IObjectContainer)		container_t;

	container_t	cont1	=	new container_t();

	// 1. push()
	printf("\nTEST: push()\n");
	printf("Populate the container with 10 integers, using push()\n");
	for(int i = 0; i < 10; ++i)
	{
		cont1.push(i);
	}
	printf("Contents: ");
	foreach(int i; cont1)
	{
		printf("%d ", i);
	}
	printf("\n");

	// dump_IObjectContainer()
	dump_IObjectContainer(cont1);

	// 2. length()
	printf("\nTEST: length()\n");
	printf("length: %u\n", cont1.length);

	// 3. Copying a container
	printf("\nTEST: copy-constructor\n");
	container_t	cont2	=	new container_t(cont1);

	// 4. pop()
	printf("\nTEST: pop()\n");
	printf("Now pop the elements (from the original), one at a time\n");
	while(cont1.length())
	{
		printf("top: %d\n", cont1.top);
		cont1.pop();
	}

	// 5. clear()
	printf("\nTEST: clear()\n");
	printf("Clear all elements from the copy\n");
	printf("length before: %u\n", cont2.length);
	cont2.clear();
	printf("length after: %u\n", cont2.length);

}

/+
void Queue_test_int_IContainer()
{
	printf("Queue!(int, IContainer!(int))\n");

//	alias Queue!(int, IContainer!(int))		container_t;
	alias Queue!(int, Container!(int))		container_t;

	container_t	cont1	=	new container_t();

	// 1. push()
	printf("\nTEST: push()\n");
	printf("Populate the container with 10 integers, using push()\n");
	for(int i = 0; i < 10; ++i)
	{
		cont1.push(i);
	}
	printf("Contents: ");
	foreach(int i; cont1)
	{
		printf("%d ", i);
	}
	printf("\n");

	// dump_IContainer_int()
//	dump_IContainer_int(cont1);

	// 2. length()
	printf("\nTEST: length()\n");
	printf("length: %u\n", cont1.length);

	// 3. Copying a container
	printf("\nTEST: copy-constructor\n");
	container_t	cont2	=	new container_t(cont1);

	// 4. pop()
	printf("\nTEST: pop()\n");
	printf("Now pop the elements (from the original), one at a time\n");
	while(cont1.length())
	{
		printf("top: %d\n", cont1.top);
		cont1.pop();
	}

	// 5. clear()
	printf("\nTEST: clear()\n");
	printf("Clear all elements from the copy\n");
	printf("length before: %u\n", cont2.length);
	cont2.clear();
	printf("length after: %u\n", cont2.length);
}
+/

int main()
{
	printf("queue_test\n");

    Queue_test_int();
	Queue_test_int_IObjectContainer();
//	Queue_test_int_IContainer();

    return 0;
}

/* ////////////////////////////////////////////////////////////////////////// */

version(MainTest)
{
    class Person
    {
    public:
        this(char[] name, int id)
        {
            m_name  =   name;
            m_id    =   id;
        }
        char[] Name()
        {
            return m_name;
        }
        int Id()
        {
            return m_id;
        }

    private:
        char[]  m_name;
        int     m_id;
    };

    struct Point
    {
        int x;
        int y;
    };

    void Queue_test_int()
    {
//      alias Queue!(int)/* .Queue */       queue_t;
        alias Queue!(int).Queue     queue_t;

        void dump(queue_t s)
        {
//          printf("Queue(%p) [%2u (%2u, %2u), %2u]:", s, s.length, s.m_front, s.m_back, s.capacity);
            printf("Queue(%p) [%2u, %2u]:", s, s.length, s.capacity);
            if(0 != s.length)
            {
                printf("  [");
                foreach(int i; s)
                {
                    printf("%d ", i);
                }
                printf("]\n");
            }
        }

        printf("Queue test (int)\n");
        printf("----------------\n");


        printf("\nCreating a new queue:\n");
        queue_t s    = new queue_t;
        dump(s);


        printf("\nPushing elements to queue:\n");
        for(int i = 0; i < 100; i += 2)
        {
            s.push(i);
        }
        dump(s);


        printf("\nCopying queue:\n");
        queue_t s2   = new queue_t(s);
        dump(s2);


        printf("\nPopping elements from queue\n");
        dump(s);
        while(!s.isEmpty())
        {
            s.pop();
            dump(s);
        }


        printf("\nPushing more elements on to queue:\n");
        for(int i = 0; i < 10; ++i)
        {
            s.push(i);
            dump(s);
        }
    }
    void Queue_test_Point()
    {
        alias Queue!(Point).Queue       queue_t;

        void dump(queue_t s)
        {
            printf("Queue(%p) [%2u, %2u]:", s, s.length, s.capacity);
            if(0 != s.length)
            {
                printf("  [");
                foreach(Point pt; s)
                {
                    printf("(%d, %d) ", pt.x, pt.y);
                }
                printf("]\n");
            }
        }

        printf("Queue test (int)\n");
        printf("----------------\n");


        printf("\nCreating a new queue:\n");
        queue_t s    = new queue_t;
        dump(s);


        printf("\nPushing elements to queue:\n");
        for(int i = 0; i < 80; i += 2)
        {
            Point   pt;

            pt.x = i;
            pt.y = i;

            s.push(pt);
        }
        dump(s);


        printf("\nCopying queue:\n");
        queue_t s2   = new queue_t(s);
        dump(s2);


        printf("\nPopping elements from queue\n");
        while(!s.isEmpty())
        {
            s.pop();
            dump(s);
        }

        printf("\nPushing more elements on to queue:\n");
        for(int i = 0; i < 10; ++i)
        {
            Point   pt;

            pt.x = i;
            pt.y = i;

            s.push(pt);
            dump(s);
        }
    }
    void Queue_test_Person()
    {
        alias Queue!(Person).Queue      queue_t;

        void dump(queue_t s)
        {
            printf("Queue(%p) [%2u, %2u]:", s, s.length, s.capacity);
            if(0 != s.length)
            {
                printf("  [");
                foreach(Person p; s)
                {
                    printf("(%.*s, %d) ", p.Name, p.Id);
                }
                printf("]\n");
            }
        }

        printf("Queue test (int)\n");
        printf("----------------\n");


        printf("\nCreating a new queue:\n");
        queue_t s    = new queue_t;
        dump(s);


        printf("\nPushing elements to queue:\n");
        for(int i = 0; i < 80; i += 2)
        {
            s.push(new Person("Me", i));
        }
        dump(s);


        printf("\nCopying queue:\n");
        queue_t s2   = new queue_t(s);
        dump(s2);


        printf("\nPopping elements from queue\n");
        while(!s.isEmpty())
        {
            s.pop();
            dump(s);
        }

        printf("\nPushing more elements on to queue:\n");
        for(int i = 0; i < 10; ++i)
        {
            s.push(new Person("Me", i));
            dump(s);
        }
    }

    int main()
    {
        Queue_test_int();
        Queue_test_Point();
        Queue_test_Person();

        return 0;
    }
}

