
private import std.box;
private import std.dtl.containers.map;

void Map_test_string_int()
{
    alias Map!(int, int)        map_t;

    void dump(map_t m)
    {
		printf("foreach()-ing pair -        ");
        printf("Map(%p) [%2u, %2u]:", m, m.length, m.capacity);
        if(0 != m.length)
        {
            printf("  [");
            foreach(map_t.pair_type p; m)
            {
                printf("[%d, %d] ", p.key, p.value);
            }
            printf("]");
        }
		printf("\n");

		printf("foreach()-ing key + value - ");
        printf("Map(%p) [%2u, %2u]:", m, m.length, m.capacity);
        if(0 != m.length)
        {
            printf("  [");
            foreach(map_t.key_type k, map_t.value_type v; m)
            {
                printf("[%d, %d] ", k, v);
            }
            printf("]");
        }
		printf("\n");
    }

    printf("Map test (int)\n");
    printf("----------------\n");


    printf("\nCreating a new map:\n");
    map_t   m   =   new map_t();


    printf("\nAdding elements to map:\n");
    for(int i = 0; i < 10; ++i)
    {
		printf("Adding: %d:%d\n", i, i * i);
        m[i] = i * i;
        dump(m);
    }

    printf("\nRemoving elements from map:\n");
    for(int i = 0; i < 10; ++i)
    {
		printf("Erasing: %d\n", i);

        m.erase(i);
        dump(m);
    }
}

void Map_test_string_Int()
{
/+
    alias Map!(int, int)        map_t;

    void dump(map_t m)
    {
		printf("foreach()-ing pair -        ");
        printf("Map(%p) [%2u, %2u]:", m, m.length, m.capacity);
        if(0 != m.length)
        {
            printf("  [");
            foreach(map_t.pair_type p; m)
            {
                printf("[%d, %d] ", p.key, p.value);
            }
            printf("]");
        }
		printf("\n");

		printf("foreach()-ing key + value - ");
        printf("Map(%p) [%2u, %2u]:", m, m.length, m.capacity);
        if(0 != m.length)
        {
            printf("  [");
            foreach(map_t.key_type k, map_t.value_type v; m)
            {
                printf("[%d, %d] ", k, v);
            }
            printf("]");
        }
		printf("\n");
    }

    printf("Map test (int)\n");
    printf("----------------\n");


    printf("\nCreating a new map:\n");
    map_t   m   =   new map_t();


    printf("\nAdding elements to map:\n");
    for(int i = 0; i < 10; ++i)
    {
		printf("Adding: %d:%d\n", i, i * i);
        m[i] = i * i;
        dump(m);
    }

    printf("\nRemoving elements from map:\n");
    for(int i = 0; i < 10; ++i)
    {
		printf("Erasing: %d\n", i);

        m.erase(i);
        dump(m);
    }
+/
}

int main()
{
    Map_test_string_int();
    Map_test_string_Int();

    return 0;
}
