
// Updated: 22nd August 2004

private import std.box;
private import std.dtl.containers.list;

void dump(int[] ar)
{
    printf("int[] enumeration[%p]:", ar);
    printf("  [");
    foreach(int i; ar)
    {
        printf("%d ", i);
    }
    printf("]");
    printf("\n");
}

void dump(List!(int).range_type r)
{
    printf("List range enumeration[%p]:", r);
    printf("  [");
    for(; r.is_open; r.advance())
    {
        printf("%d ", r.current);
    }
    printf("]");
    printf("\n");
}

version(UseIterators)
{
void dump(List!(int).iterator first, List!(int).iterator last)
{
    printf("List forward iterators [%p, %p]:", first, last);
    printf("  [");
    for(; first != last; first.next())
    {
        printf("%d ", first.value);
    }
    printf("]");
    printf("\n");
}

void dump(List!(int).reverse_iterator first, List!(int).reverse_iterator last)
{
    printf("List reverse iterators [%p, %p]:", first, last);
    printf("  [");
    for(; first != last; first.next())
    {
        printf("%d ", first.value);
    }
    printf("]");
    printf("\n");
}
} // version(UseIterators)

void dump(List!(int) l)
{
    printf("List(%p) [%2u, %2u]:", l, l.length, l.capacity);
    if(0 != l.length)
    {
        printf("  [");
        foreach(int i; l)
        {
            printf("%d ", i);
        }
        printf("]");
    }
    printf("\n");
}

int triple_fn(int i)
{
	return 3 * i;
}

class MatchInt
{
public:
	this(int value)
	{
		m_value = value;
	}

	bool opCall(int v)
	{
printf("Testing: %d\n", v);

//		return v == m_value;
		return v == 2 * m_value / 5;
	}

private:
	int	m_value;
}

void List_test_int()
{
    alias List!(int)    list_t;

	printf("\nTemplate instantiation: %.*s\n\n", "List!(int)");

    printf("List test\n");
    printf("----------------\n");


    printf("\nCreating a new list:\n");
    list_t  l    = new list_t;
    dump(l);

    printf("\nPushing elements on to back of list:\n");
    dump(l);
    for(int i = 0; i < 10; ++i)
    {
        l.push_back(i);
        dump(l);
    }


    printf("\nCopying list:\n");
    list_t  l2   = new list_t(l);
    dump(l2);


    printf("\nClearing copied list:\n");
    l2.clear();
    dump(l2);

    printf("\nPopping elements from back of list\n");
    dump(l);
    while(!l.isEmpty())
    {
        l.pop_back();
        dump(l);
    }

    printf("\nPushing elements to front of list:\n");
    dump(l);
    for(int i = 0; i < 20; i += 2)
    {
        l.push_front(i);
        dump(l);
    }

    printf("\nReversing contents of list:\n");
    l.reverse();
    dump(l);

	printf("\ndetect()-ing 10 in list:\n");
	printf("10 %.*s in list\n", l.detect(10) ? "exists" : "does not exist");

	printf("\ndetectWith()-ing 10 in list:\n");
	printf("10 %.*s in list\n", (l.detectWith!(MatchInt)(new MatchInt(10))) ? "exists" : "does not exist");


	int	maxValue;

	maxValue = l.max;
	printf("\nmax()-ing: %d\n", maxValue);

	class Less
	{
	public:
		bool opCall(int v0, int v1)
		{
//			return v0 < v1;	// Correct ordering

//			return v1 < v0;	// Reverse ordering

			return (v0 < 10) ? (v0 < v1) : (v1 < v0);
		}
	}

	maxValue = l.maxWith!(Less)(new Less());
	printf("\nmaxWith(Less)-ing: %d\n", maxValue);


version(UseIterators)
{
    printf("\nIterator access:\n");
    dump(l.begin(), l.end());

    printf("\nReverse Iterator access:\n");
    dump(l.rbegin(), l.rend());
} // version(UseIterators)

    printf("\nRange access:\n");
    dump(l[]);

    class int_doubler
    {
    public:
        int opCall(int i)
        {
            return 2 * i;
        }

		static int double_fn(int i)
		{
			return 2 * i;
		}
    }

	int double_dg(int i)
	{
		return 2 * i;
	}

	bool is_divisible_by_four(int i)
	{
		return 0 == (i % 4);
	}
	bool is_divisible_by_six(int i)
	{
		return 0 == (i % 6);
	}

    printf("\nRange: transform() - delegate\n");
	foreach(int i; l.transform(&double_dg))
	{
		printf("%d ", i);
	}
	printf("\n");
    printf("\nRange: transform() - function\n");
	foreach(int i; l.transform(&triple_fn))
	{
		printf("%d ", i);
	}
	printf("\n");

    printf("\nRange: composition - transform() delegate + transform function\n");
	foreach(int i; l.transform(&double_dg).transform(&triple_fn))
	{
		printf("%d ", i);
	}
	printf("\n");

	printf("\nRange: select() - delegate (is_divisible_by_four)\n");
	foreach(int i; l.select(&is_divisible_by_four))
	{
		printf("%d ", i);
	}
	printf("\n");

	printf("\nRange: select() - delegate (is_divisible_by_six)\n");
	foreach(int i; l.select(&is_divisible_by_six))
	{
		printf("%d ", i);
	}
	printf("\n");

    printf("\nRange: composition - select() - delegate (is_divisible_by_four) + select() - delegate (is_divisible_by_six)\n");
	foreach(int i; l.select(&is_divisible_by_four).select(&is_divisible_by_six))
	{
		printf("%d ", i);
	}
	printf("\n");


    printf("\nRange: composition - transform() delegate + select() - delegate (is_divisible_by_six)\n");
	foreach(int i; l.transform(&double_dg).select(&is_divisible_by_six))
	{
		printf("%d ", i);
	}
	printf("\n");

//    dump(l.transform1!(int_doubler)(new int_doubler()));

    printf("\nSequence contains 15: %.*s\n", toString(l.contains(15)));
    printf("\nSequence contains 16: %.*s\n", toString(l.contains(16)));

    printf("\nMinimum value: %d\n", l.min);
    printf("\nMaximum value: %d\n", l.max);

    printf("\nPopping elements from front of list\n");
    while(!l.isEmpty())
    {
        l.pop_front();
        dump(l);
    }

//      printf("\nNow iterate:\n");

//      list_t.range_type   range = l.begin();
//      printf("[ ");
//      foreach(int element; range)
//      {
//          printf("%d ", element);
//      }
//      printf("]\n");

    printf("Going up\n");
    l.clear();
    for(int i = 0, len = l.capacity; i < 10; ++i)
    {
        l.push_front(i);

        if(l.capacity != len)
        {
            len = l.capacity;
            printf("new capacity: %u\n", len);
        }
    }

    printf("Coming down\n");
    for(int len = l.capacity; !l.isEmpty(); )
    {
        l.pop_back();

        if(l.capacity != len)
        {
            len = l.capacity;
            printf("new capacity: %u\n", len);
        }
    }
}

template List_test_object(L) { void List_test_object()
{
/+
		alias	L	list_t;

		printf("\nTemplate instantiation: %.*s\n\n", "List_test_object!(List!(Object))");

		printf("List test\n");
		printf("----------------\n");


		printf("\nCreating a new list:\n");
		list_t  l    = new list_t;
//			dump(l);

		printf("\nPushing elements on to back of list:\n");
//			dump(l);
		for(int i = 0; i < 10; ++i)
		{
			l.push_back(new Box!(int)(i));
//				dump(l);
		}


		printf("\nCopying list:\n");
		list_t  l2   = new list_t(l);
//			dump(l2);


		printf("\nClearing copied list:\n");
		l2.clear();
//			dump(l2);

+/
}}

int main(char[][] args)
{
	printf("DTL Testing: list\n");

    List_test_int();
    List_test_object!(List!(Object))();
//        List_test_object!(List!(Object, IContainer))();
//        List_test_object!(List!(Object, IContainer))();

	return 0;
}

/* ////////////////////////////////////////////////////////////////////////// */
