
// Updated: 20th August 2004

import std.box;
import std.dtl.algorithms.numeric;
import std.dtl.functions.categories;
import std.dtl.range.filters;
import std.dtl.range.intrange;
import std.dtl.range.algorithms.numeric;
import std.dtl.range.algorithms.utility;

/* ////////////////////////////////////////////////////////////////////////// */

template dumpEnumerator(T)
{
	void dumpEnumerator(IEnumerator enumerator)
	{
		if(null !== enumerator)
		{
			printf("Contents, via IEnumerator: ");
			while(enumerator.hasMoreElements())
			{
				Object	o	=	enumerator.nextElement();
				T		i	=	cast(T)o;
				char[]	s;

				s ~= i.toString() ~ " ";

				printf(s);
			}
			printf("\n");
		}
	}
} // template dumpEnumerator

/* ////////////////////////////////////////////////////////////////////////// */

class IntDoubler
	: public Function!(int, int)
{
public:
    int opCall(int  i)
    {
        return 2 * i;
    }
}

class IsOdd
    : public Predicate!(int)
{
public:
//	alias Predicate!(int).argument_type	argument_type;

public:
	static bool fn(int i)
	{
        return 0 != (i % 2);
	}

    bool opCall(int i)
    {
		return fn(i);
    }
};

class IsEven
    : public Predicate!(int)
{
public:
//	alias Predicate!(int).argument_type	argument_type;

public:
	static bool fn(int i)
	{
        return 0 == (i % 2);
	}

    bool opCall(int i)
    {
		return fn(i);
    }
};

class DivisibleBy
    : public Predicate!(int)
{
public:
//	alias Predicate!(int).argument_type	argument_type;

public:
	this(int value)
	{
		m_value = value;
	}

public:
    bool opCall(int i)
    {
        return 0 == (i % m_value);
    }

private:
	int	m_value;
};

/* ////////////////////////////////////////////////////////////////////////// */

int main(char[][] args)
{
	if(0)
	{ // 
		printf("Create an IntegralRange, and process it via foreach()\n");

		alias	IntegralRange!(int)								IntegralRange_t;
		alias	MatchedRange!(IntegralRange_t, IsOdd)	FilteredIntegralRange_t;

		IntegralRange_t			r	=	new IntegralRange_t(-10, 10, 1);
		FilteredIntegralRange_t	fr	=	new FilteredIntegralRange_t(r, new IsOdd());

		printf("Unfiltered range: ");
		foreach(int i; r)
		{
			printf("%d ", i);
		}
		printf("\n");

		printf("Filtered range:   ");
		foreach(int i; fr)
		{
			printf("%d ", i);
		}
		printf("\n");

//		return 0;
	}

	return 0;
}

/* ////////////////////////////////////////////////////////////////////////// */
