
// Updated: 20th August 2004

import std.box;
import std.dtl.containers.list;
import std.dtl.containers.stack;
import std.dtl.containers.vector;
import std.dtl.algorithms.numeric;
import std.dtl.functions.categories;
import std.dtl.range.filters;
import std.dtl.range.intrange;
import std.dtl.range.algorithms.numeric;
import std.dtl.range.algorithms.utility;

/* ////////////////////////////////////////////////////////////////////////// */

template dumpEnumerator(T)
{
	void dumpEnumerator(IEnumerator enumerator)
	{
		if(null !== enumerator)
		{
			printf("Contents, via IEnumerator: ");
			while(enumerator.hasMoreElements())
			{
				Object	o	=	enumerator.nextElement();
				T		i	=	cast(T)o;
				char[]	s;

				s ~= i.toString() ~ " ";

				printf(s);
			}
			printf("\n");
		}
	}
} // template dumpEnumerator

/* ////////////////////////////////////////////////////////////////////////// */

class IntDoubler
	: public Function!(int, int)
{
public:
    int opCall(int  i)
    {
        return 2 * i;
    }
}

class IsOdd
    : public Predicate!(int)
{
public:
//	alias Predicate!(int).argument_type	argument_type;

public:
	static bool fn(int i)
	{
        return 0 != (i % 2);
	}

    bool opCall(int i)
    {
		return fn(i);
    }
};

class IsEven
    : public Predicate!(int)
{
public:
//	alias Predicate!(int).argument_type	argument_type;

public:
	static bool fn(int i)
	{
        return 0 == (i % 2);
	}

    bool opCall(int i)
    {
		return fn(i);
    }
};

class DivisibleBy
    : public Predicate!(int)
{
public:
//	alias Predicate!(int).argument_type	argument_type;

public:
	this(int value)
	{
		m_value = value;
	}

public:
    bool opCall(int i)
    {
        return 0 == (i % m_value);
    }

private:
	int	m_value;
};

/* ////////////////////////////////////////////////////////////////////////// */

int main(char[][] args)
{
	if(0)
	{ // 
		printf("Create an IntegralRange, and process it via foreach()\n");

		alias	IntegralRange!(int)								IntegralRange_t;
		alias	MatchedRange!(IntegralRange_t, IsOdd)	FilteredIntegralRange_t;

		IntegralRange_t			r	=	new IntegralRange_t(-10, 10, 1);
		FilteredIntegralRange_t	fr	=	new FilteredIntegralRange_t(r, new IsOdd());

		printf("Unfiltered range: ");
		foreach(int i; r)
		{
			printf("%d ", i);
		}
		printf("\n");

		printf("Filtered range:   ");
		foreach(int i; fr)
		{
			printf("%d ", i);
		}
		printf("\n");

//		return 0;
	}

	if(0)
	{ // 1
		printf("Create a normal vector, and process it via foreach()\n");

        alias Vector!(int)       container_t;

		container_t	cont	=	new container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		foreach(int i; new IntegralRange!(int)(0, 10, 1))
		{
			cont.push_back(i);
		}

		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);
		}
		printf("\n");
/+
		printf("Sum: %d\n", Numeric!(int).accumulate(cont, 0));
		printf("\n");
+/

/+
		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);

			cont.erase(0);

			break;
		}
		printf("\n");
+/

		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);
		}
		printf("\n");

	} // 1

	if(0)
	{ // 2
		printf("Create a vector deriving from IContainer, and process it via IContainer\n");

		alias	Box!(int)					Int;
        alias	Vector!(Int, IContainer)	container_t;

		container_t	cont	=	new container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		foreach(int i; new IntegralRange!(int)(0, 10, 1))
		{
			cont.push_back(new Int(i));
		}

		dumpEnumerator!(Int)(cont.enumerate());
	} // 2

	if(0)
	{ // 3
		printf("Create a normal vector, and process it via ranges\n");

        alias Vector!(int)  container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		container_t			cont	=	new container_t;

		foreach(int i; new IntegralRange!(int)(0, 10, 1))
		{
			cont.push_back(i);
		}

		int					total	=	dtl.range.algorithms.numeric.Numeric!(int).r_accumulate(cont[], 0);

		printf("total: %d\n", total);

		printf("Contents of range: ");
		foreach(int i; cont[2 .. cont.length])
		{
			printf("%d ", i);
		}
		printf("\n");


/+ ++ At the moment, this does not work, since DMD cannot see through the inheritance of the 
		int					length	=	dtl.range.algorithms.utility.Utility!(int).r_distance(cont[]);

		printf("length: %d\n", length);
+/

	} // 3

	{ // 11
		printf("Create a normal list, and process it via foreach()\n");

        alias List!(int)       container_t;

		container_t	cont	=	new container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		foreach(int i; new IntegralRange!(int)(-10, 10, 1))
		{
			cont.push_back(i);
		}

		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);
		}
		printf("\n");
/+
		printf("Sum: %d\n", Numeric!(int).accumulate(cont, 0));
		printf("\n");
+/

		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);
		}
		printf("\n");

        printf("\ntransform()-ing the numbers, with IntDoubler\n");
        foreach(int i; cont.transform0!(IntDoubler)())
        {
            printf("%d ", i);
        }
        printf("\n");

        printf("\ntransform()-ing the numbers, with IntDoubler, and then again\n");
		foreach(int i; cont.transform0!(IntDoubler)().transformWith0!(IntDoubler)())
		{
			printf("%d ", i);
		}
		printf("\n");

        printf("\ntransform()-ing the numbers, with IntDoubler, and then select()-ing by DivisibleBy\n");
		foreach(int i; cont.transform0!(IntDoubler)().select1!(DivisibleBy)(new DivisibleBy(4)))
		{
			printf("%d ", i);
		}
		printf("\n");

		// Select

        printf("\nselect()-ing the numbers, with IsOdd's fn, as a delegate\n");
		foreach(int i; cont.select(&IsOdd.fn))
		{
			printf("%d ", i);
		}
		printf("\n");
        printf("\nreject()-ing the numbers, with IsOdd's fn, as a delegate\n");
		foreach(int i; cont.reject(&IsOdd.fn))
		{
			printf("%d ", i);
		}
		printf("\n");
		printf("\n");

        printf("\nselect()-ing the numbers, with IsEven\n");
		foreach(int i; cont.select0!(IsEven)())
		{
			printf("%d ", i);
		}
		printf("\n");
        printf("\nreject()-ing the numbers, with IsEven\n");
		foreach(int i; cont.reject0!(IsEven)())
		{
			printf("%d ", i);
		}
		printf("\n");
		printf("\n");

        printf("\nselect()-ing the numbers, with DivisibleBy\n");
		foreach(int i; cont.select1!(DivisibleBy)(new DivisibleBy(3)))
		{
			printf("%d ", i);
		}
		printf("\n");
        printf("\nreject()-ing the numbers, with DivisibleBy\n");
		foreach(int i; cont.reject1!(DivisibleBy)(new DivisibleBy(3)))
		{
			printf("%d ", i);
		}
		printf("\n");
		printf("\n");

        printf("\nselect()-ing the numbers, with DivisibleBy's fn, as a delegate\n");
        foreach(int i; cont.select1!(DivisibleBy)(new DivisibleBy(3)).reject(&IsEven.fn))
        {
            printf("%d ", i);
        }
		printf("\n");

/+
        printf("\nselect()-ing the numbers, with DivisibleBy's fn, as a delegate\n");
		foreach(int i; cont.select1!(DivisibleBy)(new DivisibleBy(3)).reject(&IsEven.fn).select1!(DivisibleBy)(new DivisibleBy(9)))
		{
			printf("%d ", i);
		}
		printf("\n");
+/


	} // 11

	if(0)
	{ // 12
		printf("Create a list deriving from IContainer, and process it via IContainer\n");

		alias	Box!(int)				Int;
        alias	List!(Int, IContainer)	container_t;

		container_t	cont	=	new container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		foreach(int i; new IntegralRange!(int)(0, 10, 1))
		{
			cont.push_back(new Int(i));
		}

		dumpEnumerator!(Int)(cont.enumerate());
	} // 12

	if(0)
	{ // 11
		printf("Create a normal stack, and process it via foreach()\n");

        alias Stack!(int)       container_t;

		container_t	cont	=	new container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		foreach(int i; new IntegralRange!(int)(0, 10, 1))
		{
			cont.push_back(i);
		}

		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);
		}
		printf("\n");
/+
		printf("Sum: %d\n", Numeric!(int).accumulate(cont, 0));
		printf("\n");
+/

		printf("Contents: ");
		foreach(int i; cont)
		{
			printf("%d ", i);
		}
		printf("\n");

	} // 11

	if(0)
	{ // 12
		printf("Create a stack deriving from IContainer, and process it via IContainer\n");

		alias	Box!(int)				Int;
        alias	Stack!(Int, IContainer)	container_t;

		container_t	cont	=	new container_t;

		printf("Class: %.*s; size: %u\n", container_t.classinfo.name, container_t.sizeof);

		foreach(int i; new IntegralRange!(int)(0, 10, 1))
		{
			cont.push_back(new Int(i));
		}

		dumpEnumerator!(Int)(cont.enumerate());
	} // 12

	return 0;
}
