
// Created: 26th April 2004
// Updated: 18th August 2004

module std.dtl.mixins.ranges;

// This defines a template mixin.
mixin Ranges(C) // C is the mixing class.
{
private:
    typedef C.value_type    value_type; // A convenience for the mixin implementation, and also a constraint on C
    typedef C.index_type    index_type; // A convenience for the mixin implementation, and also a constraint on C

public:
    template(F)
    value_type[] transform(F f)
    {
        value_type[]  e   =   new value_type[cast(C)(this).length];
        index_type    i   =   0;

        foreach(value_type v; cast(C)(this))
        {
            e[i++] = f(v);
        }

        return e;
    }

    bool contains(value_type comperand)
    {
        foreach(value_type v; cast(C)(this))
        {
            if(v == comperand)
            {
                return true;
            }
        }

        return false;
    }

    template(F)
    bool detect(F f)
    {
        foreach(value_type v; cast(C)(this))
        {
            if(f(v))
            {
                return true;
            }
        }

        return false;
    }

    template(F)
    bool detect(F f, out value_type value)
    {
        foreach(value_type v; cast(C)(this))
        {
            if(f(v))
            {
                value = v;

                return true;
            }
        }

        return false;
    }

    // ... except this one, which is provided explicitly by Vector.
    value_type[] entries()
    {
        value_type[]  e   =   new value_type[cast(C)(this).length];
        index_type    i   =   0;

        foreach(value_type v; cast(C)(this))
        {
            e[i++] = v;
        }

        return e;
    }

    value_type min()
    {
        if(isEmpty())
        {
            // This will need to be genericised in order to work with 
            // reference types and scalar types
            return value_type.min;
        }
        else
        {
            value_type  m = value_type.max;
            foreach(value_type v; this)
            {
                if(v == value_type.min)
                {
                    return value_type.min;
                }
                else if(v < m)
                {
                    m = v;
                }
            }

            return m;
        }
    }

    template(F)
    value_type min(F f);

    value_type max()
    {
        if(isEmpty())
        {
            // This will need to be genericised in order to work with 
            // reference types and scalar types
            return value_type.max;
        }
        else
        {
            value_type  m = value_type.min;
            foreach(value_type v; this)
            {
                if(v == value_type.max)
                {
                    return value_type.max;
                }
                else if(m < v)
                {
                    m = v;
                }
            }

            return m;
        }
    }

    template(F)
    value_type  max(F f);

    template(F)
    value_type[] reject(F f) // Opposite of select
    {
        value_type[]  e   =   new value_type[cast(C)(this).length];
        index_type    i   =   0;

        foreach(value_type v; cast(C)(this))
        {
            if(!f(v))
            {
                e[i++] = v;
            }
        }

        return e[0 .. i];
    }

    template(F)
    value_type[] select(F f)
    {
        value_type[]  e   =   new value_type[cast(C)(this).length];
        index_type    i   =   0;

        foreach(value_type v; cast(C)(this))
        {
            if(f(v))
            {
                e[i++] = v;
            }
        }

        return e[0 .. i];
    }

    value_type[] sort();

    template(F)
    value_type[] sort(F f);
}



// Maybe the mixing class does not need to specify itself to the mixin, since 
// the mixin will always be mixing the mixing class, if you follow, and there 
// will never be ambiguity over the mixing class because D does not support MT.

// Hence

/+
template(T, B = EmptyBase)
{
    class List
        : B
        , mixes Ranges
    {
    public: // Could also be private, and the mixin could still see it!!!
        typedef T       value_type; // Required by the mixin
        typedef int     index_type; // Required by the mixin

        . . . // various stuff

	// Enum#1 - foreach
    public:
        int opApply( . . . ); // Required by the mixin

	// Enum#3 - Ranges
	public:
		value_type[] sort(); // List provides its own sort methods

		template(F)
		value_type[] sort(F f); // List provides its own sort methods
    }
}
+/

// Overall:
//
// - Mixins define class/instance methods. 
// - Mixins do not define *any* instance fields. (Not sure about static fields - 
//   what do you think?)
// - Mixin methods are added into the mixing class as if the user had types them
// - Mixins have *no* polymorphic aspects whatsoever. Two classes that each mix
//   the same mixin are nonetheless completely unrelated
// - Mixin methods may "become" polymorphic with respect to any interface(s) that
//   the mixing class is "implement"ing
// - If the mixing class already contains a method of the same signature, that
//   "overrides" - prevents incorporation - of that mixin method.

