/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/memory.d
 *
 * Purpose:     Memory algorithms.
 *
 * Created      14th March 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/memory.d Memory algorithms */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.memory;

/* ////////////////////////////////////////////////////////////////////////// */

extern (C)
{
    // Functions from the C library.
    void *memcpy(void *, void *, uint);
    void *memmove(void *, void *, uint);
}

template Memory(T)
{
    T *copy(T *dest, T *src, uint n)
    in
    {
        assert(null !== dest);
        assert(null !== src);
    }
    body
    {
        return cast(T*)(memcpy(dest, src, T.sizeof * n));
    }

    T *move(T *dest, T *src, uint n)
    in
    {
        assert(null !== dest);
        assert(null !== src);
    }
    body
    {
        return cast(T*)(memmove(dest, src, T.sizeof * n));
    }
}

/* ////////////////////////////////////////////////////////////////////////// */
