/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/interfaces/objectcontainer.d
 *
 * Purpose:     Object-based interfaces.
 *
 * Created      14th March 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/interfaces/objectcontainer.d Object-based interfaces */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.interfaces.objectcontainer;

/* /////////////////////////////////////////////////////////////////////////////
 * Imports
 */

import std.dtl.common;

/* /////////////////////////////////////////////////////////////////////////////
 * Container interfaces
 */

/// Permits object enumeration
interface IObjectEnumerator
{
    bool	hasMoreElements();
    Object	nextElement();
	void	release();
}

/// ObjectEnumerator class
class ObjectEnumerator
	: public IObjectEnumerator
{
public:
	alias	Object					value_type;
	alias	std.dtl.common.index_type	index_type;

public:
	this(value_type[] values)
	{
		m_values	=	values;
		m_index		=	0;
	}

public:
	bool hasMoreElements()
	{
		return m_index < m_values.length;
	}
	value_type nextElement()
	{
		return m_values[m_index++];
	}
	void release()
	{
		// No-op
	}

private:
	value_type[]	m_values;
	index_type		m_index;
}

/// The base interface for containers that will support the IObjectEnumerator interface
interface IObjectContainer
{
public:
	alias	std.dtl.common.index_type	index_type;
	alias	std.dtl.common.size_type	size_type;

public:
    alias   ObjectContainer			selected_type;

// IContainer methods
public:
    /// Denotes whether the given container is empty
    bool				isEmpty();
    /// Returns an enumerator object representing the elements of the container
    IObjectEnumerator	enumerate();
}

/// The base class for containers that will support the IObjectEnumerator interface
abstract class ObjectContainer
    : public IObjectContainer
{
public:
    bool				isEmpty();
    IObjectEnumerator	enumerate()
    {
        return new ObjectEnumerator(this.toObjectArray());
    }

protected:
    abstract Object[]   toObjectArray();
}

/* ////////////////////////////////////////////////////////////////////////// */

/+
interface ISequenceContainer
{
public:
	alias	std.dtl.common.difference_type				difference_type;
	alias	std.dtl.common.index_type					index_type;
	alias	std.dtl.common.size_type					size_type;

    // This will implement ISequenceContainer in terms of the DTL container's methods.
    class selecting_type
        : public IContainer
    {

    // Putative interface
    public:
		bool add(Object o)
		{
			this.push_back(o);

			return true;
		}
//		void clear();
		bool contains(Object o)
		{
		}
		bool equals(Object o)
		{
		}
//		bool isEmpty();
		bool remove(Object o);
		size_type size()
		{
			return this.length();
		}
		Object[] toObjectArray()
		{

		}

    // To be implemented by the container
    protected:
        abstract bool	isEmpty(); 
        abstract void	clear();
    }

/// \name ISequenceContainer methods
public:
	bool		add(Object o);
	void		clear();
	bool		contains(Object o);
	bool		equals(Object o);
	bool		isEmpty();
	bool		remove(Object o);
	size_type	size();
	Object[]	toObjectArray();
}
+/

/* ////////////////////////////////////////////////////////////////////////// */
