/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/interfaces/container.d
 *
 * Purpose:     Parameterised interfaces.
 *
 * Created      14th March 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/interfaces/container.d Parameterised interfaces */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.interfaces.container;

/* /////////////////////////////////////////////////////////////////////////////
 * Imports
 */

import std.dtl.common;

/* /////////////////////////////////////////////////////////////////////////////
 * Container interfaces
 */

/// Permits  enumeration
template IEnumerator(T)
{
	interface IEnumerator
	{
		bool	hasMoreElements();
    	T		nextElement();
		void	release();
	}
}

unittest
{
//	alias	IEnumerator!(int)	IEnumerator_int_t;
}

/// Enumerator class
template Enumerator(T)
{
	class Enumerator
		: public IEnumerator!(T)
	{
	public:
		alias	T						value_type;
		alias	std.dtl.common.index_type	index_type;

	public:
		this(value_type[] values)
		{
			m_values	=	values;
			m_index		=	0;
		}

	public:
		bool hasMoreElements()
		{
			return m_index < m_values.length;
		}
		value_type nextElement()
		{
			return m_values[m_index++];
		}
		void release()
		{
			// No-op
		}

	private:
		value_type[]	m_values;
		index_type		m_index;
	}
}

unittest
{
//	alias	Enumerator!(int)	Enumerator_int_t;
}

/// The base interface for containers that will support the IObjectEnumerator interface
template IContainer(T)
{
	interface IContainer
	{
	private:
		alias	IEnumerator!(T)				interface_type;

		static interface_type				interface_;

		alias typeof(interface_)			interface_type_;

	public:
		alias	std.dtl.common.difference_type	difference_type;
		alias	std.dtl.common.index_type		index_type;
		alias	std.dtl.common.size_type		size_type;

	public:
		alias   Container!(T)				selected_type;

	// IContainer methods
	public:
		/// Denotes whether the given container is empty
		bool			isEmpty();
		/// Returns an enumerator representing the elements of the container
//		interface_type	enumerate();
		interface_type_	enumerate();
	}
}

unittest
{
//	alias	IContainer!(int)	IContainer_int_t;
}

/// The base class for containers that will support the IObjectEnumerator interface
template Container(T)
{
	abstract class Container
		: public IContainer!(T)
	{
	public:
		alias	T				value_type;

	// This is a hack, until IContainer!(T) is usable.
		alias   Container		selected_type;

	public:
		bool			isEmpty();
		IEnumerator!(T)	enumerate()
		{
			return new Enumerator!(T)(this.toArray());
		}

	protected:
		abstract value_type[]   toArray();
	}
}

unittest
{
//	alias	Container!(int)	Container_int_t;
}

/* ////////////////////////////////////////////////////////////////////////// */
