/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/functions/predicates.d
 *
 * Purpose:     DTL predicates.
 *
 * Created      16th July 2004
 * Updated:     20th August 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/functions/predicates.d DTL predicates */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.functions.predicates;

/* /////////////////////////////////////////////////////////////////////////////
 * Imports
 */

import std.dtl.common;
import std.dtl.functions.categories;

/* ////////////////////////////////////////////////////////////////////////// */

template Not(F) { class Not
    : public Predicate!(F.argument_type)
{
public:
	alias	Not			class_type;

public:
    this(F f)
    {
        m_f = f;
    }
/+
    this()
    {
        m_f = new F();
    }
+/

public:
    bool opCall(argument_type v)
    {
        return !m_f(v);
    }

private:
    F   m_f;
}}

/* ////////////////////////////////////////////////////////////////////////// */

class Equals(F) { class Equals
	: public Predicate!(F, F)
{
public:
	alias	Equals	class_type;

public:
    bool opCall(argument0_type v1, argument0_type v2)
    {
        return (v1 == v2) ? true : false;
    }
}}

/* ////////////////////////////////////////////////////////////////////////// */

template Less(F) { class Less
	: public Predicate!(F, F)
{
public:
	alias	Less	class_type;

public:
    bool opCall(argument0_type v1, argument0_type v2)
    {
        return v1.compare(v2) < 0;
    }
}}

/* ////////////////////////////////////////////////////////////////////////// */

template DelegatePredicate(D, A) { class DelegatePredicate
	: public Predicate!(A)
{
public:
	alias	DelegatePredicate	class_type;

public:
    this(D d)
    {
        m_d = d;
    }

public:
    bool opCall(argument_type v)
    {
        return m_d(v);
    }

private:
    D   m_d;
}}

/* ////////////////////////////////////////////////////////////////////////// */

template FunctionPredicate(F, A) { class FunctionPredicate
	: public Predicate!(A)
{
public:
	alias	FunctionPredicate	class_type;

public:
    this(F f)
    {
        m_f = f;
    }

public:
    bool opCall(argument_type v)
    {
        return m_f(v);
    }

private:
    F   m_f;
}}

/* ////////////////////////////////////////////////////////////////////////// */
