/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/functions/functions.d
 *
 * Purpose:     DTL functions.
 *
 * Created      16th July 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/functions/functions.d DTL functions */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.functions.functions;

/* /////////////////////////////////////////////////////////////////////////////
 * Imports
 */

import std.dtl.common;
import std.dtl.functions.categories;

/* ////////////////////////////////////////////////////////////////////////// */

template Negate(F) { class Not
    : public Function!(F.return_type, F.argument0_type)
{
public:
	alias	Negate	class_type;

public:
    this(F f)
    {
        m_f = f;
    }
/+
    this()
    {
        m_f = new F();
    }
+/

public:
    return_type opCall(argument0_type v)
    {
        return !m_f(v);
    }

private:
    F   m_f;
}}

/* ////////////////////////////////////////////////////////////////////////// */

template DelegateFunction(D, R, A0) { class DelegateFunction
	: public Function!(R, A0)
{
public:
	alias	DelegateFunction	class_type;

public:
    this(D d)
    {
        m_d = d;
    }

public:
    return_type opCall(argument0_type v)
    {
        return m_d(v);
    }

private:
    D   m_d;
}}

/* ////////////////////////////////////////////////////////////////////////// */

template FunctionFunction(F, R, A0) { class FunctionFunction
	: public Function!(R, A0)
{
public:
	alias	FunctionFunction	class_type;

public:
    this(F f)
    {
        m_f = f;
    }

public:
    return_type opCall(argument0_type v)
    {
        return m_f(v);
    }

private:
    F   m_f;
}}

/* ////////////////////////////////////////////////////////////////////////// */
