/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/functions/categories.d
 *
 * Purpose:     DTL function categories.
 *
 * Created      16th July 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/functions/categories.d DTL function categories */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.functions.categories;

/* ////////////////////////////////////////////////////////////////////////// */

interface IFunction
{}

    interface IPredicate
        : public IFunction
    {}

/* ////////////////////////////////////////////////////////////////////////// */

template Function(R, A0) { class Function
    : public IFunction
{
public:
    alias R     return_type;
    alias A0    argument0_type;
}}

template Function(R, A0, A1) { class Function
    : public IFunction
{
public:
    alias R     return_type;
    alias A0    argument0_type;
    alias A1    argument1_type;
}}

template Function(R, A0, A1, A2) { class Function
    : public IFunction
{
public:
    alias R     return_type;
    alias A0    argument0_type;
    alias A1    argument1_type;
    alias A2    argument2_type;
}}

/* ////////////////////////////////////////////////////////////////////////// */

template Predicate(A0) { class Predicate
    : public IPredicate
{
public:
    alias bool  return_type;
    alias A0    argument_type;
}}

template Predicate(A0, A1) { class Predicate
    : public IPredicate
{
public:
    alias bool  return_type;
    alias A0    argument0_type;
    alias A1    argument1_type;
}}

/* ////////////////////////////////////////////////////////////////////////// */
