/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/common.d
 *
 * Purpose:     DTL common functionality.
 *
 * Created      14th March 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/common.d DTL common functionality */

/* ////////////////////////////////////////////////////////////////////////// */


module std.dtl.common;

/* /////////////////////////////////////////////////////////////////////////////
 * Typedefs
 */

alias	ptrdiff_t		difference_type;
alias	ptrdiff_t		index_type;
alias	size_t			size_type;

/* /////////////////////////////////////////////////////////////////////////////
 * Enumerations
 */

/// Stipulates the iterator direction
public enum IteratorDirection
{
        forward	/*!< Indicates forward iteration */
    ,   reverse	/*!< Indicates reverse iteration */
}

/* /////////////////////////////////////////////////////////////////////////////
 * Base type selection
 */

/// \brief This is the base class of 
public class EmptyBase
{}

/// \brief This template is used to select the base class of a deriving type
///
/// For any type T, the BaseSelector(T).selected_type is the base class of a
/// deriving type.
///
/// 
template BaseSelector(T)
{
	alias	T.selected_type					selected_type;
}
template BaseSelector(T : EmptyBase)
{
    alias   EmptyBase						selected_type;
}

/* /////////////////////////////////////////////////////////////////////////////
 * Container interfaces
 */

/+
interface ISequenceContainer
{
public:
	alias	std.dtl.common.difference_type				difference_type;
	alias	std.dtl.common.index_type					index_type;
	alias	std.dtl.common.size_type					size_type;

    // This will implement ISequenceContainer in terms of the DTL container's methods.
    class selecting_type
        : public IContainer
    {

    // Putative interface
    public:
		bool add(Object o)
		{
			this.push_back(o);

			return true;
		}
//		void clear();
		bool contains(Object o)
		{
		}
		bool equals(Object o)
		{
		}
//		bool isEmpty();
		bool remove(Object o);
		size_type size()
		{
			return this.length();
		}
		Object[] toObjectArray()
		{

		}

    // To be implemented by the container
    protected:
        abstract bool	isEmpty(); 
        abstract void	clear();
    }

/// \name ISequenceContainer methods
public:
	bool		add(Object o);
	void		clear();
	bool		contains(Object o);
	bool		equals(Object o);
	bool		isEmpty();
	bool		remove(Object o);
	size_type	size();
	Object[]	toObjectArray();
}
+/

/* ////////////////////////////////////////////////////////////////////////// */
