/* /////////////////////////////////////////////////////////////////////////////
 * File:        std/dtl/algorithms/numeric.d
 *
 * Purpose:     Numeric algorithms.
 *
 * Created      13th July 2004
 * Updated:     31st July 2004
 *
 * www:         http://www.synesis.com.au/software/
 *
 * Copyright (C) 2004 by Matthew Wilson
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file std/dtl/algorithms/numeric.d Numeric algorithms */

/* ////////////////////////////////////////////////////////////////////////// */

module std.dtl.algorithms.numeric;

/* ////////////////////////////////////////////////////////////////////////// */

template Numeric(T)
{
    T accumulate(T *from, T *to, T initial)
    in
    {
        assert(null !== from);
        assert(null !== to);
    }
    body
    {
		for(; from != to; ++from)
		{
			initial += *from;
		}

        return initial;
    }

/+
	// This doesn't work, because 
    T accumulate(T range, T initial)
    in
    {
        assert(null !== range);
    }
    body
    {
		foreach(T val; range)
		{
			initial += val;
		}

        return initial;
    }
+/
}

/* ////////////////////////////////////////////////////////////////////////// */
