/* /////////////////////////////////////////////////////////////////////////////
 * File:        boxutil.d
 *
 * Purpose:     Boxing for built-in types.
 *
 * Created      13th July 2004
 * Updated:     29th July 2004
 *
 * www:         http://www.synesis.com.au/software
 *              http://www.synsoft.org/
 *
 * Copyright (C) 2004 by Matthew Wilson and Synesis Software
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file box.d Boxing for built-in types */

/* ////////////////////////////////////////////////////////////////////////// */

module std.boxutil;

/* /////////////////////////////////////////////////////////////////////////////
 * Imports
 */

private import std.box;
private import std.string;

/* ////////////////////////////////////////////////////////////////////////// */

int compare(bit lhs, bit rhs)
{
	return compare(cast(int)lhs, cast(int)rhs);
}

int compare(byte lhs, byte rhs)
{
	return compare(cast(int)lhs, cast(int)rhs);
}

int compare(ubyte lhs, ubyte rhs)
{
	return compare(cast(int)lhs, cast(int)rhs);
}

int compare(short lhs, short rhs)
{
	return compare(cast(int)lhs, cast(int)rhs);
}

int compare(ushort lhs, ushort rhs)
{
	return compare(cast(int)lhs, cast(int)rhs);
}

int compare(int lhs, int rhs)
{
	return lhs - rhs;
}

int compare(uint lhs, uint rhs)
{
	return compare(cast(int)lhs, cast(int)rhs);
}

int compare(Object lhs, Object rhs)
{
	return lhs.opCmp(rhs);
}

/* ////////////////////////////////////////////////////////////////////////// */

char[] toString(bit v)
{
	return std.string.toString(v);
}

char[] toString(byte v)
{
	return std.string.toString(v);
}

char[] toString(ubyte v)
{
	return std.string.toString(v);
}

char[] toString(short v)
{
	return std.string.toString(v);
}

char[] toString(ushort v)
{
	return std.string.toString(v);
}

char[] toString(int v)
{
	return std.string.toString(v);
}

char[] toString(uint v)
{
	return std.string.toString(v);
}

char[] toString(long v)
{
	return std.string.toString(v);
}

char[] toString(ulong v)
{
	return std.string.toString(v);
}

char[] toString(Object v)
{
	return v.toString();
}

/* ////////////////////////////////////////////////////////////////////////// */

Object toObject(bit v)
{
	return new Box!(bit)(v);
}

Object toObject(byte v)
{
	return new Box!(byte)(v);
}

Object toObject(ubyte v)
{
	return new Box!(ubyte)(v);
}

Object toObject(short v)
{
	return new Box!(short)(v);
}

Object toObject(ushort v)
{
	return new Box!(ushort)(v);
}

Object toObject(int v)
{
	return new Box!(int)(v);
}

Object toObject(uint v)
{
	return new Box!(uint)(v);
}

Object toObject(long v)
{
	return new Box!(long)(v);
}

Object toObject(ulong v)
{
	return new Box!(ulong)(v);
}

Object toObject(Object v)
{
	return v;
}

/* ////////////////////////////////////////////////////////////////////////// */

Object[] toObjectArray(bit[] ar)
{
	Object[]	objects;

	foreach(bit v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(byte[] ar)
{
	Object[]	objects;

	foreach(byte v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(ubyte[] ar)
{
	Object[]	objects;

	foreach(ubyte v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(short[] ar)
{
	Object[]	objects;

	foreach(short v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(ushort[] ar)
{
	Object[]	objects;

	foreach(ushort v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(int[] ar)
{
	Object[]	objects;

	foreach(int v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(uint[] ar)
{
	Object[]	objects;

	foreach(uint v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(long[] ar)
{
	Object[]	objects;

	foreach(long v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(ulong[] ar)
{
	Object[]	objects;

	foreach(ulong v; ar)
	{
		objects ~= toObject(v);
	}

	return objects;
}

Object[] toObjectArray(Object[] ar)
{
	return ar.dup;
}

/* ////////////////////////////////////////////////////////////////////////// */
