/* /////////////////////////////////////////////////////////////////////////////
 * File:        box.d
 *
 * Purpose:     Boxing for built-in types.
 *
 * Created      13th July 2004
 * Updated:     1st August 2004
 *
 * www:         http://www.synesis.com.au/software
 *              http://www.synsoft.org/
 *
 * Copyright (C) 2004 by Matthew Wilson and Synesis Software
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation would be appreciated but is
 * not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution. 
 *
 * ////////////////////////////////////////////////////////////////////////// */


/** \file box.d Boxing for built-in types
 *
 * \author Matthew Wilson
 * \author Sage contributions from: Carlos Santander (opCast)
 */

/* ////////////////////////////////////////////////////////////////////////// */

module std.box;

/* /////////////////////////////////////////////////////////////////////////////
 * Imports
 */

import std.boxutil;

/* ////////////////////////////////////////////////////////////////////////// */

class Box(T, R = T)
{
/// \name Types
/// @{
public:
	alias	T		value_type;
	alias	R		reference_type;
	alias	Box		class_type;
/// @}

/// \name Construction
/// @{
public:
    this(reference_type value)
    {
        m_value = value;
    }
/// @}

/// \name Comparison
/// @{
public:
	int opEquals(class_type rhs)
	in
	{
		assert(null !== rhs);
	}
	body
	{
		return rhs.m_value == m_value;
	}
	int opCmp(class_type rhs)
	in
	{
		assert(null !== rhs);
	}
	body
	{
/+
		value_type	lhs_	=	m_value;
		value_type	rhs_	=	rhs.m_value;
+/
// TODO: Fix this when DMD works correctly
		int			lhs_	=	cast(int)(m_value);
		int			rhs_	=	cast(int)(rhs.m_value);

        return std.boxutil.compare(lhs_, rhs_);
	}
/// @}

/// \name Accessors
/// @{
public:
    reference_type value()
    {
        return m_value;
    }

	reference_type opCast()
	{
		return value();
	}

    static class_type min()
    {
        return new Box(value_type.min);
    }

    static class_type max()
    {
        return new Box(value_type.max);
    }

    char[] toString()
    {
        return std.boxutil.toString(m_value);
    }
/// @}

/// Members
private:
    value_type  m_value;
}

/* ////////////////////////////////////////////////////////////////////////// */
